/*
 * Decompiled with CFR 0.152.
 */
package drawables.dom;

import com.intellij.util.ui.UIUtil;
import drawables.ItemDrawableInflater;
import drawables.Utils;
import drawables.dom.Drawable;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J4\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldrawables/dom/ScaleDrawable;", "Ldrawables/dom/Drawable;", "()V", "drawable", "gravity", "", "scaleHeight", "", "scaleWidth", "draw", "", "image", "Ljava/awt/image/BufferedImage;", "inflate", "element", "Lorg/w3c/dom/Element;", "resolveGravity", "Lkotlin/Pair;", "parentHeight", "containerHeight", "parentWidth", "containerWidth", "Companion", "drawable-preview"})
public final class ScaleDrawable
extends Drawable {
    private Drawable drawable;
    private float scaleWidth = 1.0f;
    private float scaleHeight = 1.0f;
    private int gravity = 51;
    private static final String SCALE_HEIGHT = "android:scaleHeight";
    private static final String SCALE_WIDTH = "android:scaleWidth";
    private static final String SCALE_GRAVITY = "android:scaleGravity";
    public static final Companion Companion = new Companion(null);

    @Override
    public void inflate(@NotNull Element element) {
        block2: {
            int it;
            float it2;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super.inflate(element);
            this.drawable = ItemDrawableInflater.Companion.getDrawableWithInflate(element);
            String string = element.getAttribute(SCALE_HEIGHT);
            if (string != null) {
                object = string;
                String $receiver = object;
                object = Float.valueOf(Utils.Companion.parseAttributeAsPercent($receiver, this.scaleHeight));
                this.scaleHeight = it2 = ((Number)object).floatValue();
            }
            String string2 = element.getAttribute(SCALE_WIDTH);
            if (string2 != null) {
                object = string2;
                String $receiver = object;
                object = Float.valueOf(Utils.Companion.parseAttributeAsPercent($receiver, this.scaleWidth));
                this.scaleWidth = it2 = ((Number)object).floatValue();
            }
            String string3 = element.getAttribute(SCALE_GRAVITY);
            if (string3 == null) break block2;
            Object $receiver = object = string3;
            object = Utils.Companion.parseAttributeAsGravity((String)$receiver, this.gravity);
            this.gravity = it = ((Number)object).intValue();
        }
    }

    @Override
    public void draw(@NotNull BufferedImage image) {
        block1: {
            Graphics graphics;
            BufferedImage scaledImage;
            Drawable drawable;
            Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
            super.draw(image);
            Drawable drawable2 = this.drawable;
            if (drawable2 == null) break block1;
            Drawable it = drawable = drawable2;
            int width = Math.round((float)image.getWidth() * this.scaleWidth);
            int height = Math.round((float)image.getHeight() * this.scaleHeight);
            if (width <= 0 || height <= 0) {
                return;
            }
            Pair<Integer, Integer> resolvedGravity = this.resolveGravity(image.getHeight(), height, image.getWidth(), width);
            BufferedImage bufferedImage = scaledImage = UIUtil.createImage((int)image.getWidth(), (int)image.getHeight(), (int)2);
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage, (String)"scaledImage");
            it.draw(bufferedImage);
            Graphics $receiver = graphics = image.getGraphics();
            $receiver.drawImage(scaledImage, ((Number)resolvedGravity.getFirst()).intValue(), ((Number)resolvedGravity.getSecond()).intValue(), width, height, null);
            $receiver.dispose();
        }
    }

    private final Pair<Integer, Integer> resolveGravity(int parentHeight, int containerHeight, int parentWidth, int containerWidth) {
        int yValue;
        int n;
        switch (this.gravity & 7) {
            case 3: 
            case 0x800003: {
                n = 0;
                break;
            }
            case 1: {
                n = (parentWidth - containerWidth) / 2;
                break;
            }
            case 5: 
            case 0x800005: {
                n = parentWidth - containerWidth;
                break;
            }
            default: {
                n = 0;
            }
        }
        int xValue = n;
        switch (this.gravity & 0x70) {
            case 48: {
                int n2 = 0;
                break;
            }
            case 16: {
                int n2 = (parentHeight - containerHeight) / 2;
                break;
            }
            case 80: {
                int n2 = parentHeight - containerHeight;
                break;
            }
            default: {
                int n2 = yValue = 0;
            }
        }
        if (xValue < 0) {
            xValue = 0;
        }
        if (yValue < 0) {
            yValue = 0;
        }
        return new Pair((Object)xValue, (Object)yValue);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ldrawables/dom/ScaleDrawable$Companion;", "", "()V", "SCALE_GRAVITY", "", "SCALE_HEIGHT", "SCALE_WIDTH", "drawable-preview"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

