/*
 * Decompiled with CFR 0.152.
 */
package drawables.dom;

import com.intellij.util.ui.UIUtil;
import drawables.ItemDrawableInflater;
import drawables.Utils;
import drawables.dom.Drawable;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldrawables/dom/RotateDrawable;", "Ldrawables/dom/Drawable;", "()V", "degrees", "", "drawable", "draw", "", "image", "Ljava/awt/image/BufferedImage;", "inflate", "element", "Lorg/w3c/dom/Element;", "Companion", "drawable-preview"})
public final class RotateDrawable
extends Drawable {
    private Drawable drawable;
    private int degrees;
    private static final String FROM_DEGREES = "android:fromDegrees";
    public static final Companion Companion = new Companion(null);

    @Override
    public void inflate(@NotNull Element element) {
        block0: {
            int it;
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super.inflate(element);
            this.drawable = ItemDrawableInflater.Companion.getDrawableWithInflate(element);
            String string = element.getAttribute(FROM_DEGREES);
            if (string == null) break block0;
            Object object = string;
            String $receiver = object;
            object = Utils.Companion.parseAttributeAsInt($receiver, this.degrees);
            this.degrees = it = ((Number)object).intValue();
        }
    }

    @Override
    public void draw(@NotNull BufferedImage image) {
        block0: {
            Graphics2D graphics2D;
            BufferedImage newImage;
            Drawable drawable;
            Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
            super.draw(image);
            Drawable drawable2 = this.drawable;
            if (drawable2 == null) break block0;
            Drawable it = drawable = drawable2;
            BufferedImage bufferedImage = newImage = UIUtil.createImage((int)image.getWidth(), (int)image.getHeight(), (int)2);
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage, (String)"newImage");
            it.draw(bufferedImage);
            AffineTransform identity = new AffineTransform();
            AffineTransform rotateTransform = new AffineTransform();
            rotateTransform.setTransform(identity);
            rotateTransform.rotate(Math.toRadians(this.degrees), (double)image.getWidth() / 2.0, (double)image.getHeight() / 2.0);
            Graphics2D $receiver = graphics2D = image.createGraphics();
            $receiver.drawImage(newImage, rotateTransform, null);
            $receiver.dispose();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldrawables/dom/RotateDrawable$Companion;", "", "()V", "FROM_DEGREES", "", "drawable-preview"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

