/*
 * Decompiled with CFR 0.152.
 */
package drawables.dom;

import drawables.ItemDrawableInflater;
import drawables.Utils;
import drawables.dom.Drawable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldrawables/dom/RippleDrawable;", "Ldrawables/dom/Drawable;", "()V", "backgroundDrawable", "color", "Ljava/awt/Color;", "draw", "", "image", "Ljava/awt/image/BufferedImage;", "inflate", "element", "Lorg/w3c/dom/Element;", "Companion", "drawable-preview"})
public final class RippleDrawable
extends Drawable {
    private Color color = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private Drawable backgroundDrawable;
    private static final String COLOR = "android:color";
    private static final String ITEM_TAG = "item";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public void inflate(@NotNull Element element) {
        Object it;
        Object object;
        String $receiver;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.inflate(element);
        Object object2 = element.getAttribute(COLOR);
        if (object2 != null && (object2 = Utils.Companion.parseAttributeAsColor($receiver = (object = object2), this.color)) != null) {
            it = object = object2;
            this.color = new Color(((Color)it).getRed(), ((Color)it).getGreen(), ((Color)it).getBlue(), (int)127.5f);
        }
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            it = object = nodeList;
            int $i$a$2$also = 0;
            int n = it.getLength();
            while ($i$a$2$also < n) {
                void i;
                Node childNode = it.item((int)i);
                if (childNode instanceof Element) {
                    String string = ((Element)childNode).getTagName();
                    if (string != null) {
                        if (string.equals(ITEM_TAG)) {
                            this.backgroundDrawable = ItemDrawableInflater.Companion.getDrawableWithInflate((Element)childNode);
                            break;
                        }
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void draw(@NotNull BufferedImage image) {
        Graphics2D graphics2D;
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        super.draw(image);
        Drawable drawable = this.backgroundDrawable;
        if (drawable != null) {
            drawable.draw(image);
        }
        Graphics2D it = graphics2D = image.createGraphics();
        int resolvedSize = (int)((float)image.getWidth() * 0.5f);
        it.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Graphics2D graphics2D2 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics2D2, (String)"it");
        graphics2D2.setColor(this.color);
        it.fillOval(image.getWidth() / 2 - resolvedSize / 2, image.getHeight() / 2 - resolvedSize / 2, resolvedSize, resolvedSize);
        it.dispose();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldrawables/dom/RippleDrawable$Companion;", "", "()V", "COLOR", "", "ITEM_TAG", "drawable-preview"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

