/*
 * Decompiled with CFR 0.152.
 */
package drawables.dom;

import drawables.dom.Drawable;
import drawables.dom.LayerDrawableItem;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldrawables/dom/LayerDrawable;", "Ldrawables/dom/Drawable;", "()V", "drawables", "Ljava/util/ArrayList;", "Ldrawables/dom/LayerDrawableItem;", "Lkotlin/collections/ArrayList;", "draw", "", "image", "Ljava/awt/image/BufferedImage;", "inflate", "element", "Lorg/w3c/dom/Element;", "resolveDimens", "Companion", "drawable-preview"})
public final class LayerDrawable
extends Drawable {
    private final ArrayList<LayerDrawableItem> drawables = new ArrayList();
    private static final String ITEM_TAG = "item";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public void inflate(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.inflate(element);
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            NodeList nodeList2;
            NodeList it = nodeList2 = nodeList;
            int n = 0;
            int n2 = it.getLength();
            while (n < n2) {
                void i;
                Node childNode = it.item((int)i);
                if (childNode instanceof Element) {
                    String string = ((Element)childNode).getTagName();
                    if (string != null) {
                        if (string.equals(ITEM_TAG)) {
                            this.drawables.add(new LayerDrawableItem((Element)childNode));
                        }
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void draw(@NotNull BufferedImage image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        super.draw(image);
        this.resolveDimens(image);
        for (LayerDrawableItem drawable : this.drawables) {
            drawable.draw(image);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveDimens(BufferedImage image) {
        void $receiver$iv$iv;
        int maxAttrSize;
        LayerDrawableItem it;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.drawables;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it = (LayerDrawableItem)element$iv$iv;
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])new Integer[]{it.getHeight(), it.getWidth()});
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Integer n = (Integer)CollectionsKt.max((Iterable)((List)destination$iv$iv));
        int n2 = maxAttrSize = n != null ? n : 0;
        if (maxAttrSize > 0) {
            throw (Throwable)new UnsupportedOperationException();
        }
        Iterable $receiver$iv2 = this.drawables;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            LayerDrawableItem it2 = (LayerDrawableItem)element$iv$iv;
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])new Integer[]{it2.getLeft(), it2.getTop(), it2.getRight(), it2.getBottom()});
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Integer n3 = (Integer)CollectionsKt.max((Iterable)((List)destination$iv$iv2));
        float maxPaddingArg = n3 != null ? (float)n3.intValue() : 0.0f;
        float maxPaddingWidth = (float)image.getWidth() * 0.3f;
        Iterable $receiver$iv3 = this.drawables;
        for (Object element$iv : $receiver$iv3) {
            it = (LayerDrawableItem)element$iv;
            it.setWidth(image.getWidth());
            it.setHeight(image.getHeight());
            it.setLeft((int)((float)it.getLeft() / maxPaddingArg * maxPaddingWidth));
            it.setTop((int)((float)it.getTop() / maxPaddingArg * maxPaddingWidth));
            it.setRight((int)((float)it.getRight() / maxPaddingArg * maxPaddingWidth));
            it.setBottom((int)((float)it.getBottom() / maxPaddingArg * maxPaddingWidth));
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldrawables/dom/LayerDrawable$Companion;", "", "()V", "ITEM_TAG", "", "drawable-preview"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

