/*
 * Decompiled with CFR 0.152.
 */
package drawables.dom;

import com.intellij.util.ui.UIUtil;
import drawables.ItemDrawableInflater;
import drawables.Utils;
import drawables.dom.Drawable;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldrawables/dom/InsetDrawable;", "Ldrawables/dom/Drawable;", "()V", "drawable", "insetBottom", "", "insetLeft", "insetRight", "insetTop", "draw", "", "image", "Ljava/awt/image/BufferedImage;", "inflate", "element", "Lorg/w3c/dom/Element;", "Companion", "drawable-preview"})
public final class InsetDrawable
extends Drawable {
    private Drawable drawable;
    private int insetTop;
    private int insetLeft;
    private int insetRight;
    private int insetBottom;
    private static final String INSET = "android:inset";
    private static final String INSET_TOP = "android:insetTop";
    private static final String INSET_LEFT = "android:insetLeft";
    private static final String INSET_RIGHT = "android:insetRight";
    private static final String INSET_BOTTOM = "android:insetBottom";
    public static final Companion Companion = new Companion(null);

    @Override
    public void inflate(@NotNull Element element) {
        block4: {
            int it;
            int it2;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super.inflate(element);
            this.drawable = ItemDrawableInflater.Companion.getDrawableWithInflate(element);
            String string = element.getAttribute(INSET);
            if (string != null) {
                object = string;
                String $receiver = object;
                object = Utils.Companion.parseAttributeAsInt($receiver, 0);
                this.insetTop = it2 = ((Number)object).intValue();
                this.insetLeft = it2 = ((Number)object).intValue();
                this.insetRight = it2 = ((Number)object).intValue();
                this.insetBottom = it2 = ((Number)object).intValue();
            }
            String string2 = element.getAttribute(INSET_TOP);
            if (string2 != null) {
                object = string2;
                String $receiver = object;
                object = Utils.Companion.parseAttributeAsInt($receiver, this.insetTop);
                this.insetTop = it2 = ((Number)object).intValue();
            }
            String string3 = element.getAttribute(INSET_LEFT);
            if (string3 != null) {
                Object $receiver = object = string3;
                object = Utils.Companion.parseAttributeAsInt((String)$receiver, this.insetLeft);
                this.insetLeft = it2 = ((Number)object).intValue();
            }
            String string4 = element.getAttribute(INSET_RIGHT);
            if (string4 != null) {
                Object $receiver = object = string4;
                object = Utils.Companion.parseAttributeAsInt((String)$receiver, this.insetRight);
                this.insetRight = it2 = ((Number)object).intValue();
            }
            String string5 = element.getAttribute(INSET_BOTTOM);
            if (string5 == null) break block4;
            Object $receiver = object = string5;
            object = Utils.Companion.parseAttributeAsInt((String)$receiver, this.insetBottom);
            this.insetBottom = it = ((Number)object).intValue();
        }
    }

    @Override
    public void draw(@NotNull BufferedImage image) {
        block1: {
            Graphics graphics;
            BufferedImage imageWithInsets;
            Drawable drawable;
            Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
            super.draw(image);
            Drawable drawable2 = this.drawable;
            if (drawable2 == null) break block1;
            Drawable it = drawable = drawable2;
            Integer n = (Integer)ArraysKt.max((Comparable[])new Integer[]{this.insetTop, this.insetLeft, this.insetRight, this.insetBottom});
            float maxValueAsFloat = n != null ? n : this.insetLeft;
            int maxInsetSize = image.getWidth() / 5;
            this.insetTop = (int)((float)this.insetTop / maxValueAsFloat * (float)maxInsetSize);
            this.insetLeft = (int)((float)this.insetLeft / maxValueAsFloat * (float)maxInsetSize);
            this.insetRight = (int)((float)this.insetRight / maxValueAsFloat * (float)maxInsetSize);
            this.insetBottom = (int)((float)this.insetBottom / maxValueAsFloat * (float)maxInsetSize);
            int width = image.getWidth() - this.insetLeft - this.insetRight;
            int height = image.getHeight() - this.insetTop - this.insetBottom;
            if (width <= 0 || height <= 0) {
                return;
            }
            BufferedImage bufferedImage = imageWithInsets = UIUtil.createImage((int)width, (int)height, (int)2);
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage, (String)"imageWithInsets");
            it.draw(bufferedImage);
            Graphics $receiver = graphics = image.getGraphics();
            $receiver.drawImage(imageWithInsets, this.insetLeft, this.insetTop, width, height, null);
            $receiver.dispose();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ldrawables/dom/InsetDrawable$Companion;", "", "()V", "INSET", "", "INSET_BOTTOM", "INSET_LEFT", "INSET_RIGHT", "INSET_TOP", "drawable-preview"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

