/*
 * Decompiled with CFR 0.152.
 */
package drawables.dom;

import com.intellij.util.ui.UIUtil;
import drawables.Utils;
import drawables.dom.Drawable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 R2\u00020\u0001:\u0001RB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0002J\u001d\u00104\u001a\u0004\u0018\u0001052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b07H\u0002\u00a2\u0006\u0002\u00108J\b\u00109\u001a\u00020:H\u0002J\u001b\u0010;\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b07H\u0002\u00a2\u0006\u0002\u00108J\u0012\u0010<\u001a\u00020:2\b\b\u0002\u0010=\u001a\u00020>H\u0002J\u001b\u0010?\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b07H\u0002\u00a2\u0006\u0002\u00108J\b\u0010@\u001a\u00020:H\u0002J\u0012\u0010A\u001a\u00020:2\b\b\u0002\u0010=\u001a\u00020>H\u0002J\u001b\u0010B\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b07H\u0002\u00a2\u0006\u0002\u00108J\u0010\u0010C\u001a\u00020-2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020-2\u0006\u0010D\u001a\u00020EH\u0002J'\u0010G\u001a\u00020-2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010H\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010IJ\u0010\u0010J\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u001f\u0010K\u001a\u00020-2\u0006\u0010)\u001a\u00020\u00042\b\u0010H\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010LJ\u0010\u0010M\u001a\u00020-2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010N\u001a\u00020-2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010O\u001a\u00020-2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010P\u001a\u00020-2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010Q\u001a\u00020-2\u0006\u0010D\u001a\u00020EH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Ldrawables/dom/GradientDrawable;", "Ldrawables/dom/Drawable;", "()V", "bottomLeftHeightRadius", "", "bottomLeftRadius", "bottomLeftWidthRadius", "bottomRightHeightRadius", "bottomRightRadius", "bottomRightWidthRadius", "centerGradientColor", "Ljava/awt/Color;", "color", "dashGap", "dashGapWidth", "endGradientColor", "gradientAngle", "", "gradientCenterX", "gradientCenterY", "gradientRadius", "gradientType", "height", "innerRadius", "innerRadiusRatio", "resolvedHeight", "resolvedStrokeWidth", "resolvedWidth", "shape", "startGradientColor", "strokeColor", "strokeWidth", "thickness", "thicknessRatio", "tintColor", "topLeftHeightRadius", "topLeftRadius", "topLeftWidthRadius", "topRightHeightRadius", "topRightRadius", "topRightWidthRadius", "width", "createStroke", "Ljava/awt/Stroke;", "draw", "", "image", "Ljava/awt/image/BufferedImage;", "drawShape", "graphics", "Ljava/awt/Graphics2D;", "drawStroke", "getGradientPaint", "Ljava/awt/Paint;", "gradientColors", "", "([Ljava/awt/Color;)Ljava/awt/Paint;", "getLinePath", "Ljava/awt/Shape;", "getLinearGradient", "getOval", "forStroke", "", "getRadialGradient", "getRing", "getRoundPath", "getSweepGradient", "inflate", "element", "Lorg/w3c/dom/Element;", "inflateChildElements", "resolveCorners", "maxValue", "(FFLjava/lang/Float;)V", "resolveDimensions", "resolveStroke", "(FLjava/lang/Float;)V", "updateCorners", "updateGradient", "updateSize", "updateSolid", "updateStroke", "Companion", "drawable-preview"})
public final class GradientDrawable
extends Drawable {
    private int shape;
    private int innerRadius = -1;
    private float innerRadiusRatio = 9.0f;
    private Color tintColor;
    private int thickness = -1;
    private float thicknessRatio = 9.0f;
    private int width = -1;
    private int height = -1;
    private int resolvedWidth = this.width;
    private int resolvedHeight = this.height;
    private float gradientCenterX = -1.0f;
    private float gradientCenterY = -1.0f;
    private int gradientType;
    private Color startGradientColor;
    private Color centerGradientColor;
    private Color endGradientColor;
    private int gradientAngle;
    private float gradientRadius = 0.5f;
    private Color color;
    private Color strokeColor;
    private int strokeWidth = -1;
    private float dashGap;
    private float dashGapWidth;
    private float resolvedStrokeWidth = this.strokeWidth;
    private float topLeftRadius;
    private float topRightRadius;
    private float bottomLeftRadius;
    private float bottomRightRadius;
    private float topLeftWidthRadius;
    private float topLeftHeightRadius;
    private float topRightWidthRadius;
    private float topRightHeightRadius;
    private float bottomRightWidthRadius;
    private float bottomRightHeightRadius;
    private float bottomLeftWidthRadius;
    private float bottomLeftHeightRadius;
    private static final String SHAPE = "android:shape";
    private static final String OVAL_SHAPE = "oval";
    private static final String LINE = "line";
    private static final String RING = "ring";
    private static final String INNER_RADIUS = "android:innerRadius";
    private static final String INNER_RADIUS_RATIO = "android:innerRadiusRatio";
    private static final String THICKNESS = "android:thickness";
    private static final String THICKNESS_RATIO = "android:thicknessRatio";
    private static final String SIZE = "size";
    private static final String WIDTH = "android:width";
    private static final String HEIGHT = "android:height";
    private static final String TINT = "android:tint";
    private static final String GRADIENT = "gradient";
    private static final String ANGLE = "android:angle";
    private static final String CENTER_COLOR = "android:centerColor";
    private static final String CENTER_X = "android:centerX";
    private static final String CENTER_Y = "android:centerY";
    private static final String END_COLOR = "android:endColor";
    private static final String GRADIENT_RADIUS = "android:gradientRadius";
    private static final String START_COLOR = "android:startColor";
    private static final String TYPE = "android:type";
    private static final String RADIAL_GRADIENT_TYPE = "radial";
    private static final String SWEEP_GRADIENT_TYPE = "sweep";
    private static final String SOLID = "solid";
    private static final String COLOR = "android:color";
    private static final String STROKE = "stroke";
    private static final String DASH_GAP = "android:dashGap";
    private static final String DASH_WIDTH = "android:dashWidth";
    private static final String CORNERS = "corners";
    private static final String RADIUS = "android:radius";
    private static final String TOP_LEFT_RADIUS = "android:topLeftRadius";
    private static final String BOTTOM_LEFT_RADIUS = "android:bottomLeftRadius";
    private static final String BOTTOM_RIGHT_RADIUS = "android:bottomRightRadius";
    private static final String TOP_RIGHT_RADIUS = "android:topRightRadius";
    private static final int DEFAULT_INT_VALUE = -1;
    private static final float DEFAULT_INNER_RADIUS_RATIO = 9.0f;
    private static final float DEFAULT_THICKNESS_RATIO = 9.0f;
    public static final Companion Companion = new Companion(null);

    @Override
    public void inflate(@NotNull Element element) {
        Object it;
        Object object;
        String $receiver;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.inflate(element);
        Object object2 = element.getAttribute(TINT);
        if (object2 != null && (object2 = Utils.Companion.parseAttributeAsColor($receiver = (object = object2), this.tintColor)) != null) {
            this.tintColor = it = (object = object2);
        }
        String string = element.getAttribute(SHAPE);
        if (string != null) {
            int n;
            it = object = string;
            switch (it) {
                case "oval": {
                    n = 1;
                    break;
                }
                case "line": {
                    n = 2;
                    break;
                }
                case "ring": {
                    n = 3;
                    break;
                }
                default: {
                    n = this.shape;
                }
            }
            object = n;
            this.shape = it = ((Number)object).intValue();
        }
        if (this.shape == 3) {
            String string2 = element.getAttribute(INNER_RADIUS);
            if (string2 != null) {
                int it2;
                Object $receiver2 = object = string2;
                object = Utils.Companion.parseAttributeAsInt((String)$receiver2, this.innerRadius);
                this.innerRadius = it2 = ((Number)object).intValue();
            }
            if (this.innerRadius == -1) {
                String string3 = element.getAttribute(INNER_RADIUS_RATIO);
                if (string3 != null) {
                    float it3;
                    Object $receiver3 = object = string3;
                    object = Float.valueOf(Utils.Companion.parseAttributeAsFloat((String)$receiver3, this.innerRadiusRatio));
                    this.innerRadiusRatio = it3 = ((Number)object).floatValue();
                }
            }
            String string4 = element.getAttribute(THICKNESS);
            if (string4 != null) {
                int it4;
                Object $receiver4 = object = string4;
                object = Utils.Companion.parseAttributeAsInt((String)$receiver4, this.thickness);
                this.thickness = it4 = ((Number)object).intValue();
            }
            if (this.thickness == -1) {
                String string5 = element.getAttribute(THICKNESS_RATIO);
                if (string5 != null) {
                    float it5;
                    Object $receiver5 = object = string5;
                    object = Float.valueOf(Utils.Companion.parseAttributeAsFloat((String)$receiver5, this.thicknessRatio));
                    this.thicknessRatio = it5 = ((Number)object).floatValue();
                }
            }
        }
        this.inflateChildElements(element);
    }

    /*
     * Unable to fully structure code
     */
    private final void inflateChildElements(Element element) {
        block8: {
            v0 = element.getChildNodes();
            if (v0 == null) break block8;
            it = var2_2 = v0;
            var4_4 = 0;
            var5_5 = it.getLength();
            while (var4_4 < var5_5) {
                block9: {
                    block10: {
                        block13: {
                            block11: {
                                block12: {
                                    childNode = it.item((int)i);
                                    if (!(childNode instanceof Element)) break block9;
                                    v1 = var7_7 = ((Element)childNode).getTagName();
                                    if (v1 == null) break block9;
                                    switch (v1.hashCode()) {
                                        case 955046078: {
                                            if (!var7_7.equals("corners")) ** break;
                                            break block10;
                                        }
                                        case 109618859: {
                                            if (!var7_7.equals("solid")) ** break;
                                            break block11;
                                        }
                                        case 3530753: {
                                            if (!var7_7.equals("size")) ** break;
                                            break;
                                        }
                                        case 89650992: {
                                            if (!var7_7.equals("gradient")) ** break;
                                            break block12;
                                        }
                                        case -891980232: {
                                            if (!var7_7.equals("stroke")) ** break;
                                            break block13;
                                        }
                                    }
                                    this.updateSize((Element)childNode);
                                    ** break;
                                }
                                this.updateGradient((Element)childNode);
                                ** break;
                            }
                            this.updateSolid((Element)childNode);
                            ** break;
                        }
                        this.updateStroke((Element)childNode);
                        ** break;
                    }
                    this.updateCorners((Element)childNode);
                }
                ++i;
            }
        }
    }

    private final void updateSize(Element element) {
        block1: {
            int it;
            Object object;
            String string = element.getAttribute(WIDTH);
            if (string != null) {
                int it2;
                object = string;
                String $receiver = object;
                object = Utils.Companion.parseAttributeAsInt($receiver, this.width);
                this.width = it2 = ((Number)object).intValue();
            }
            String string2 = element.getAttribute(HEIGHT);
            if (string2 == null) break block1;
            object = string2;
            String $receiver = object;
            object = Utils.Companion.parseAttributeAsInt($receiver, this.height);
            this.height = it = ((Number)object).intValue();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateGradient(Element element) {
        block12: {
            block10: {
                block11: {
                    v0 = element.getAttribute("android:centerX");
                    if (v0 != null) {
                        var2_2 = v0;
                        $receiver = var2_2;
                        var2_2 = Float.valueOf(Utils.Companion.parseAttributeAsFloat($receiver, this.gradientCenterX));
                        this.gradientCenterX = it = ((Number)var2_2).floatValue();
                    }
                    v1 = element.getAttribute("android:centerY");
                    if (v1 != null) {
                        var2_2 = v1;
                        $receiver = var2_2;
                        var2_2 = Float.valueOf(Utils.Companion.parseAttributeAsFloat($receiver, this.gradientCenterY));
                        this.gradientCenterY = it = ((Number)var2_2).floatValue();
                    }
                    v2 = element.getAttribute("android:type");
                    if (v2 == null) break block10;
                    $i$a$4$also = $receiver = (var2_2 = v2);
                    switch ($i$a$4$also.hashCode()) {
                        case 109850348: {
                            if (!$i$a$4$also.equals("sweep")) ** break;
                            break;
                        }
                        case -938579425: {
                            if (!$i$a$4$also.equals("radial")) ** break;
                            v3 = 1;
                            break block11;
                        }
                    }
                    v3 = 2;
                    break block11;
                    v3 = this.gradientType;
                }
                var2_2 = v3;
                this.gradientType = it = ((Number)var2_2).intValue();
            }
            if ((v4 = element.getAttribute("android:startColor")) != null && (v4 = Utils.Companion.parseAttributeAsColor((String)($receiver = (var2_2 = v4)), this.startGradientColor)) != null) {
                this.startGradientColor = it = (var2_2 = v4);
            }
            if ((v5 = element.getAttribute("android:centerColor")) != null && (v5 = Utils.Companion.parseAttributeAsColor((String)($receiver = (var2_2 = v5)), this.centerGradientColor)) != null) {
                this.centerGradientColor = it = (var2_2 = v5);
            }
            if ((v6 = element.getAttribute("android:endColor")) != null && (v6 = Utils.Companion.parseAttributeAsColor((String)($receiver = (var2_2 = v6)), this.endGradientColor)) != null) {
                this.endGradientColor = it = (var2_2 = v6);
            }
            v7 = element.getAttribute("android:angle");
            if (v7 != null) {
                $receiver = var2_2 = v7;
                var2_2 = Utils.Companion.parseAttributeAsInt((String)$receiver, this.gradientAngle);
                this.gradientAngle = it = ((Number)var2_2).intValue();
            }
            v8 = element.getAttribute("android:gradientRadius");
            if (v8 == null) break block12;
            $receiver = var2_2 = v8;
            var2_2 = Float.valueOf(Utils.Companion.parseAttributeAsFloat((String)$receiver, this.gradientRadius));
            this.gradientRadius = it = ((Number)var2_2).floatValue();
        }
    }

    private final void updateSolid(Element element) {
        block0: {
            Object it;
            Object object;
            String $receiver;
            Object object2 = element.getAttribute(COLOR);
            if (object2 == null || (object2 = Utils.Companion.parseAttributeAsColor($receiver = (object = object2), this.color)) == null) break block0;
            this.color = it = (object = object2);
        }
    }

    private final void updateStroke(Element element) {
        block3: {
            float it;
            Object object;
            String $receiver;
            Object object2 = element.getAttribute(COLOR);
            if (object2 != null && (object2 = Utils.Companion.parseAttributeAsColor($receiver = (object = object2), this.strokeColor)) != null) {
                Object it2;
                this.strokeColor = it2 = (object = object2);
            }
            String string = element.getAttribute(WIDTH);
            if (string != null) {
                int it3;
                object = string;
                $receiver = object;
                object = Utils.Companion.parseAttributeAsInt($receiver, this.strokeWidth);
                this.strokeWidth = it3 = ((Number)object).intValue();
            }
            String string2 = element.getAttribute(DASH_GAP);
            if (string2 != null) {
                float it4;
                Object $receiver2 = object = string2;
                object = Float.valueOf(Utils.Companion.parseAttributeAsFloat((String)$receiver2, this.dashGap));
                this.dashGap = it4 = ((Number)object).floatValue();
            }
            String string3 = element.getAttribute(DASH_WIDTH);
            if (string3 == null) break block3;
            Object $receiver3 = object = string3;
            object = Float.valueOf(Utils.Companion.parseAttributeAsFloat((String)$receiver3, this.dashGapWidth));
            this.dashGapWidth = it = ((Number)object).floatValue();
        }
    }

    private final void updateCorners(Element element) {
        block4: {
            float it;
            float it2;
            Object object;
            String string = element.getAttribute(RADIUS);
            if (string != null) {
                object = string;
                String $receiver = object;
                object = Float.valueOf(Utils.Companion.parseAttributeAsFloat($receiver, 0.0f));
                this.topLeftRadius = it2 = ((Number)object).floatValue();
                this.topRightRadius = it2 = ((Number)object).floatValue();
                this.bottomLeftRadius = it2 = ((Number)object).floatValue();
                this.bottomRightRadius = it2 = ((Number)object).floatValue();
            }
            String string2 = element.getAttribute(TOP_LEFT_RADIUS);
            if (string2 != null) {
                object = string2;
                String $receiver = object;
                object = Float.valueOf(Utils.Companion.parseAttributeAsFloat($receiver, this.topLeftRadius));
                this.topLeftRadius = it2 = ((Number)object).floatValue();
            }
            String string3 = element.getAttribute(TOP_RIGHT_RADIUS);
            if (string3 != null) {
                Object $receiver = object = string3;
                object = Float.valueOf(Utils.Companion.parseAttributeAsFloat((String)$receiver, this.topRightRadius));
                this.topRightRadius = it2 = ((Number)object).floatValue();
            }
            String string4 = element.getAttribute(BOTTOM_LEFT_RADIUS);
            if (string4 != null) {
                Object $receiver = object = string4;
                object = Float.valueOf(Utils.Companion.parseAttributeAsFloat((String)$receiver, this.bottomLeftRadius));
                this.bottomLeftRadius = it2 = ((Number)object).floatValue();
            }
            String string5 = element.getAttribute(BOTTOM_RIGHT_RADIUS);
            if (string5 == null) break block4;
            Object $receiver = object = string5;
            object = Float.valueOf(Utils.Companion.parseAttributeAsFloat((String)$receiver, this.bottomRightRadius));
            this.bottomRightRadius = it = ((Number)object).floatValue();
        }
    }

    @Override
    public void draw(@NotNull BufferedImage image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        super.draw(image);
        this.resolveDimensions(image);
        BufferedImage resizedImage = UIUtil.createImage((int)this.resolvedWidth, (int)this.resolvedHeight, (int)2);
        Graphics2D resizedGraphics = resizedImage.createGraphics();
        resizedGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Graphics2D graphics2D = resizedGraphics;
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics2D, (String)"resizedGraphics");
        this.drawShape(graphics2D);
        this.drawStroke(resizedGraphics);
        Graphics2D graphics2D2 = image.createGraphics();
        if (graphics2D2 != null) {
            Graphics2D graphics2D3;
            Graphics2D it = graphics2D3 = graphics2D2;
            it.drawImage((Image)resizedImage, (image.getWidth() - this.resolvedWidth) / 2, (image.getHeight() - this.resolvedHeight) / 2, null);
            it.dispose();
        }
        resizedGraphics.dispose();
    }

    private final void resolveDimensions(BufferedImage image) {
        this.resolvedWidth = image.getWidth();
        this.resolvedHeight = image.getHeight();
        if (this.shape == 2) {
            this.resolveStroke(this.resolvedWidth, null);
            return;
        }
        if (this.shape == 3) {
            return;
        }
        Float maxValue = null;
        if (this.width > 0 && this.height > 0) {
            maxValue = Float.valueOf(Math.max(this.width, this.height));
            this.resolvedWidth = (int)((float)image.getWidth() * ((float)this.width / maxValue.floatValue()));
            this.resolvedHeight = (int)((float)image.getHeight() * ((float)this.height / maxValue.floatValue()));
            this.gradientRadius = (float)image.getHeight() * (this.gradientRadius / maxValue.floatValue());
        } else {
            this.gradientRadius = image.getWidth();
        }
        this.resolveCorners(this.resolvedWidth, this.resolvedHeight, maxValue);
        this.resolveStroke(this.resolvedWidth, maxValue);
    }

    private final void resolveCorners(float width, float height, Float maxValue) {
        block4: {
            float half;
            float f;
            float maxCorner;
            Float f2 = ArraysKt.max((Float[])new Float[]{Float.valueOf(this.topLeftRadius), Float.valueOf(this.topRightRadius), Float.valueOf(this.bottomRightRadius), Float.valueOf(this.bottomLeftRadius)});
            float f3 = maxCorner = f2 != null ? f2.floatValue() * 4.0f : 0.0f;
            if (!(maxCorner > 0.0f)) break block4;
            Float f4 = maxValue;
            float maxValueToUse = f4 != null ? f4.floatValue() : maxCorner;
            float f5 = height * (this.topLeftRadius / maxValueToUse);
            GradientDrawable gradientDrawable = this;
            float it = f5;
            gradientDrawable.topLeftHeightRadius = f = Math.min(it, height);
            f5 = width * (this.topLeftRadius / maxValueToUse);
            gradientDrawable = this;
            it = f5;
            gradientDrawable.topLeftWidthRadius = f = Math.min(it, width);
            f5 = height * (this.topRightRadius / maxValueToUse);
            gradientDrawable = this;
            it = f5;
            gradientDrawable.topRightHeightRadius = f = Math.min(it, height);
            f5 = width * (this.topRightRadius / maxValueToUse);
            gradientDrawable = this;
            it = f5;
            gradientDrawable.topRightWidthRadius = f = Math.min(it, width);
            f5 = height * (this.bottomRightRadius / maxValueToUse);
            gradientDrawable = this;
            it = f5;
            gradientDrawable.bottomRightHeightRadius = f = Math.min(it, height);
            f5 = width * (this.bottomRightRadius / maxValueToUse);
            gradientDrawable = this;
            it = f5;
            gradientDrawable.bottomRightWidthRadius = f = Math.min(it, width);
            f5 = height * (this.bottomLeftRadius / maxValueToUse);
            gradientDrawable = this;
            it = f5;
            gradientDrawable.bottomLeftHeightRadius = f = Math.min(it, height);
            f5 = width * (this.bottomLeftRadius / maxValueToUse);
            gradientDrawable = this;
            it = f5;
            gradientDrawable.bottomLeftWidthRadius = f = Math.min(it, width);
            Float f6 = Float.valueOf(this.topLeftWidthRadius + this.topRightWidthRadius);
            it = ((Number)f6).floatValue();
            Float f7 = it > width ? f6 : null;
            if (f7 != null) {
                f6 = f7;
                it = ((Number)f6).floatValue();
                half = (it - width) / (float)2;
                this.topLeftWidthRadius -= half;
                this.topRightWidthRadius -= half;
            }
            f6 = Float.valueOf(this.bottomLeftWidthRadius + this.bottomRightWidthRadius);
            it = ((Number)f6).floatValue();
            Float f8 = it > width ? f6 : null;
            if (f8 != null) {
                f6 = f8;
                it = ((Number)f6).floatValue();
                half = (it - width) / (float)2;
                this.bottomLeftWidthRadius -= half;
                this.bottomRightWidthRadius -= half;
            }
            f6 = Float.valueOf(this.topLeftHeightRadius + this.bottomLeftHeightRadius);
            it = ((Number)f6).floatValue();
            Float f9 = it > height ? f6 : null;
            if (f9 != null) {
                f6 = f9;
                it = ((Number)f6).floatValue();
                half = (it - height) / (float)2;
                this.topLeftHeightRadius -= half;
                this.bottomLeftHeightRadius -= half;
            }
            f6 = Float.valueOf(this.topRightHeightRadius + this.bottomRightHeightRadius);
            it = ((Number)f6).floatValue();
            Float f10 = it > height ? f6 : null;
            if (f10 != null) {
                f6 = f10;
                it = ((Number)f6).floatValue();
                half = (it - height) / (float)2;
                this.topRightHeightRadius -= half;
                this.bottomRightHeightRadius -= half;
            }
        }
    }

    private final void resolveStroke(float width, Float maxValue) {
        if (maxValue != null) {
            float f;
            float f2 = width * ((float)this.strokeWidth / maxValue.floatValue());
            GradientDrawable gradientDrawable = this;
            float it = f2;
            gradientDrawable.resolvedStrokeWidth = f = Math.min(it, width * 0.5f);
            this.dashGap = width * (this.dashGap / maxValue.floatValue()) * (float)2;
            this.dashGapWidth = width * (this.dashGap / maxValue.floatValue());
        } else {
            this.resolvedStrokeWidth = width * 0.1f;
            if (this.dashGap > 0.0f || this.dashGapWidth > 0.0f) {
                this.dashGap = this.resolvedStrokeWidth;
                this.dashGapWidth = this.resolvedStrokeWidth;
            }
        }
    }

    private final void drawShape(Graphics2D graphics) {
        Shape shapeToUse;
        Shape shape;
        List gradientColors = ArraysKt.filterNotNull((Object[])new Color[]{this.startGradientColor, this.centerGradientColor, this.endGradientColor});
        if (gradientColors.isEmpty()) {
            graphics.setColor(this.color);
        } else {
            Color[] colorArray = new Color[3];
            Color color = this.startGradientColor;
            if (color == null) {
                Color color2 = Color.BLACK;
                color = color2;
                Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"Color.BLACK");
            }
            colorArray[0] = color;
            Color color3 = this.centerGradientColor;
            if (color3 == null) {
                Color color4 = Color.BLACK;
                color3 = color4;
                Intrinsics.checkExpressionValueIsNotNull((Object)color4, (String)"Color.BLACK");
            }
            colorArray[1] = color3;
            Color color5 = this.endGradientColor;
            if (color5 == null) {
                Color color6 = Color.BLACK;
                color5 = color6;
                Intrinsics.checkExpressionValueIsNotNull((Object)color6, (String)"Color.BLACK");
            }
            colorArray[2] = color5;
            graphics.setPaint(this.getGradientPaint(colorArray));
        }
        switch (this.shape) {
            case 1: {
                shape = GradientDrawable.getOval$default(this, false, 1, null);
                break;
            }
            case 0: {
                shape = GradientDrawable.getRoundPath$default(this, false, 1, null);
                break;
            }
            case 3: {
                shape = this.getRing();
                break;
            }
            default: {
                shape = null;
            }
        }
        Shape shape2 = shapeToUse = shape;
        if (shape2 != null) {
            Shape shape3;
            Shape it = shape3 = shape2;
            graphics.fill(it);
        }
        graphics.setColor(null);
        graphics.setPaint(null);
    }

    private final Paint getGradientPaint(Color[] gradientColors) {
        Paint paint;
        switch (this.gradientType) {
            case 0: {
                paint = this.getLinearGradient(gradientColors);
                break;
            }
            case 1: {
                paint = this.getRadialGradient(gradientColors);
                break;
            }
            case 2: {
                paint = this.getSweepGradient(gradientColors);
                break;
            }
            default: {
                paint = null;
            }
        }
        return paint;
    }

    private final Paint getLinearGradient(Color[] gradientColors) {
        float widthF = this.resolvedWidth;
        float heightF = this.resolvedHeight;
        int resolvedAngle = this.gradientAngle % 360;
        float startX = 0.0f;
        float startY = 0.0f;
        float endX = 0.0f;
        float endY = 0.0f;
        switch (resolvedAngle) {
            case 0: {
                endX = widthF;
                break;
            }
            case 45: {
                startY = heightF;
                endX = widthF;
                break;
            }
            case 90: {
                startY = heightF;
                break;
            }
            case 135: {
                startX = widthF;
                startY = heightF;
                break;
            }
            case 180: {
                startX = widthF;
                break;
            }
            case 225: {
                startX = widthF;
                endY = heightF;
                break;
            }
            case 270: {
                endY = heightF;
                break;
            }
            case 315: {
                endX = widthF;
                endY = heightF;
            }
        }
        float f = this.gradientCenterX;
        float f2 = this.gradientCenterY;
        float it = f = Math.max(f, f2);
        float maxGradientCenter = it < 0.0f ? 0.5f : (it == 0.0f ? 0.01f : (it >= 1.0f ? 0.99f : it));
        return new LinearGradientPaint(startX, startY, endX, endY, new float[]{0.0f, maxGradientCenter, 1.0f}, gradientColors);
    }

    private final Paint getRadialGradient(Color[] gradientColors) {
        return new RadialGradientPaint(this.gradientCenterX * (float)this.resolvedWidth, this.gradientCenterY * (float)this.resolvedHeight, this.gradientRadius, new float[]{0.0f, 0.5f, 1.0f}, gradientColors);
    }

    private final Paint getSweepGradient(Color[] gradientColors) {
        return new RadialGradientPaint(0.5f * (float)this.resolvedWidth, 0.5f * (float)this.resolvedHeight, this.resolvedWidth, new float[]{0.0f, 0.5f, 1.0f}, gradientColors);
    }

    private final void drawStroke(Graphics2D graphics) {
        block6: {
            Shape shapeToUse;
            Shape shape;
            if (!(this.resolvedStrokeWidth > 0.0f)) break block6;
            graphics.setColor(this.strokeColor);
            graphics.setStroke(this.createStroke());
            switch (this.shape) {
                case 1: {
                    shape = this.getOval(true);
                    break;
                }
                case 0: {
                    shape = this.getRoundPath(true);
                    break;
                }
                case 2: {
                    shape = this.getLinePath();
                    break;
                }
                default: {
                    shape = null;
                }
            }
            Shape shape2 = shapeToUse = shape;
            if (shape2 != null) {
                Shape shape3;
                Shape it = shape3 = shape2;
                graphics.draw(it);
            }
        }
    }

    private final Stroke createStroke() {
        if (this.dashGap == 0.0f || this.dashGapWidth == 0.0f) {
            return new BasicStroke(this.resolvedStrokeWidth);
        }
        return new BasicStroke(this.resolvedStrokeWidth, 0, 1, 1.0f, new float[]{this.dashGap, this.dashGapWidth}, 0.0f);
    }

    private final Shape getOval(boolean forStroke) {
        Shape shape;
        if (forStroke) {
            float halfStroke = this.resolvedStrokeWidth / (float)2;
            shape = new Ellipse2D.Float(halfStroke, halfStroke, (float)this.resolvedWidth - this.resolvedStrokeWidth, (float)this.resolvedHeight - this.resolvedStrokeWidth);
        } else {
            shape = new Ellipse2D.Float(0.0f, 0.0f, this.resolvedWidth, this.resolvedHeight);
        }
        return shape;
    }

    static /* bridge */ /* synthetic */ Shape getOval$default(GradientDrawable gradientDrawable, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return gradientDrawable.getOval(bl);
    }

    private final Shape getRoundPath(boolean forStroke) {
        Path2D.Float float_;
        if (forStroke) {
            Path2D.Float float_2;
            Path2D.Float $receiver = float_2 = new Path2D.Float();
            float widthF = this.resolvedWidth;
            float heightF = this.resolvedHeight;
            float halfStroke = this.resolvedStrokeWidth / (float)2;
            float left = halfStroke - 0.5f;
            float top = halfStroke - 0.5f;
            float right = widthF - halfStroke;
            float bottom = heightF - halfStroke;
            $receiver.moveTo(right - this.topRightWidthRadius + halfStroke, top);
            $receiver.lineTo(right - this.topRightWidthRadius + halfStroke, top);
            $receiver.quadTo(right, top, right, top + this.topRightHeightRadius - halfStroke);
            $receiver.lineTo(right, bottom - this.bottomRightHeightRadius + halfStroke);
            $receiver.quadTo(right, bottom, right - this.bottomRightWidthRadius + halfStroke, bottom);
            $receiver.lineTo(left + this.bottomLeftWidthRadius - halfStroke, bottom);
            $receiver.quadTo(left, bottom, left, bottom - this.bottomLeftHeightRadius + halfStroke);
            $receiver.lineTo(left, top + this.topLeftHeightRadius - halfStroke);
            $receiver.quadTo(left, top, left + this.topLeftWidthRadius - halfStroke, top);
            $receiver.closePath();
            return float_2;
        }
        Path2D.Float $receiver = float_ = new Path2D.Float();
        float widthF = this.resolvedWidth;
        float heightF = this.resolvedHeight;
        $receiver.moveTo(0.0f, 0.0f);
        $receiver.lineTo(widthF - this.topRightWidthRadius, 0.0f);
        $receiver.quadTo(widthF, 0.0f, widthF, 0.0f + this.topRightHeightRadius);
        $receiver.lineTo(widthF, heightF - this.bottomRightHeightRadius);
        $receiver.quadTo(widthF, heightF, widthF - this.bottomRightWidthRadius, heightF);
        $receiver.lineTo(0.0f + this.bottomLeftWidthRadius, heightF);
        $receiver.quadTo(0.0f, heightF, 0.0f, heightF - this.bottomLeftHeightRadius);
        $receiver.lineTo(0.0f, 0.0f + this.topLeftHeightRadius);
        $receiver.quadTo(0.0f, 0.0f, 0.0f + this.topLeftWidthRadius, 0.0f);
        $receiver.closePath();
        return float_;
    }

    static /* bridge */ /* synthetic */ Shape getRoundPath$default(GradientDrawable gradientDrawable, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return gradientDrawable.getRoundPath(bl);
    }

    private final Shape getLinePath() {
        float f;
        float it = f = (float)this.resolvedHeight / 2.0f;
        return new Line2D.Float(0.0f, it, this.resolvedWidth, it);
    }

    private final Shape getRing() {
        float widthF = this.resolvedWidth;
        float heightF = this.resolvedHeight;
        float centerX = widthF / (float)2;
        float centerY = heightF / (float)2;
        double outerRadius = (double)widthF / 2.0;
        float resolvedThickness = widthF * 0.3f;
        Ellipse2D.Double outer = new Ellipse2D.Double((double)centerX - outerRadius, (double)centerY - outerRadius, outerRadius + outerRadius, outerRadius + outerRadius);
        Ellipse2D.Double inner = new Ellipse2D.Double((double)centerX - outerRadius + (double)resolvedThickness, (double)centerY - outerRadius + (double)resolvedThickness, outerRadius + outerRadius - (double)resolvedThickness - (double)resolvedThickness, outerRadius + outerRadius - (double)resolvedThickness - (double)resolvedThickness);
        Area area = new Area(outer);
        area.subtract(new Area(inner));
        return area;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u001a\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ldrawables/dom/GradientDrawable$Companion;", "", "()V", "ANGLE", "", "BOTTOM_LEFT_RADIUS", "BOTTOM_RIGHT_RADIUS", "CENTER_COLOR", "CENTER_X", "CENTER_Y", "COLOR", "CORNERS", "DASH_GAP", "DASH_WIDTH", "DEFAULT_INNER_RADIUS_RATIO", "", "DEFAULT_INT_VALUE", "", "DEFAULT_THICKNESS_RATIO", "END_COLOR", "GRADIENT", "GRADIENT_RADIUS", "HEIGHT", "INNER_RADIUS", "INNER_RADIUS_RATIO", "LINE", "OVAL_SHAPE", "RADIAL_GRADIENT_TYPE", "RADIUS", "RING", "SHAPE", "SIZE", "SOLID", "START_COLOR", "STROKE", "SWEEP_GRADIENT_TYPE", "THICKNESS", "THICKNESS_RATIO", "TINT", "TOP_LEFT_RADIUS", "TOP_RIGHT_RADIUS", "TYPE", "WIDTH", "drawable-preview"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

