/*
 * Decompiled with CFR 0.152.
 */
package drawables.dom;

import com.intellij.psi.PsiFile;
import com.intellij.util.ui.UIUtil;
import drawables.Utils;
import drawables.dom.Drawable;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldrawables/dom/BitmapDrawable;", "Ldrawables/dom/Drawable;", "()V", "icon", "Ljavax/swing/Icon;", "tintColor", "Ljava/awt/Color;", "draw", "", "image", "Ljava/awt/image/BufferedImage;", "inflate", "element", "Lorg/w3c/dom/Element;", "Companion", "drawable-preview"})
public final class BitmapDrawable
extends Drawable {
    private Icon icon;
    private Color tintColor;
    private static final String SRC = "android:src";
    private static final String TINT = "android:tint";
    public static final Companion Companion = new Companion(null);

    @Override
    public void inflate(@NotNull Element element) {
        block1: {
            Object object;
            String $receiver;
            Object object2;
            Object it;
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super.inflate(element);
            String string = element.getAttribute(SRC);
            if (string != null && (string = Utils.Companion.getPsiFileFromPath((String)(it = (object2 = string)))) != null) {
                object2 = string;
                $receiver = object2;
                this.icon = IconPreviewFactory.Companion.createIconInner((PsiFile)$receiver);
            }
            if ((object = element.getAttribute(TINT)) == null || (object = Utils.Companion.parseAttributeAsColor($receiver = (object2 = object), this.tintColor)) == null) break block1;
            this.tintColor = it = (object2 = object);
        }
    }

    @Override
    public void draw(@NotNull BufferedImage image) {
        block1: {
            Icon icon;
            Icon it;
            Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
            super.draw(image);
            Icon icon2 = this.icon;
            if (icon2 == null || !((it = (icon = icon2)) instanceof ImageIcon)) break block1;
            int width = ((ImageIcon)it).getImage().getWidth(null);
            int height = ((ImageIcon)it).getImage().getHeight(null);
            BufferedImage dyed = UIUtil.createImage((int)width, (int)height, (int)2);
            Graphics2D graphics = dyed.createGraphics();
            graphics.drawImage(((ImageIcon)it).getImage(), 0, 0, null);
            Color color = this.tintColor;
            if (color != null) {
                Color color2;
                Color it2 = color2 = color;
                Graphics2D graphics2D = graphics;
                Intrinsics.checkExpressionValueIsNotNull((Object)graphics2D, (String)"graphics");
                graphics2D.setComposite(AlphaComposite.SrcAtop);
                graphics.setColor(this.tintColor);
                graphics.fillRect(0, 0, width, height);
            }
            graphics.dispose();
            BufferedImage bufferedImage = dyed;
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage, (String)"dyed");
            Utils.Companion.drawResizedIcon(bufferedImage, image);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldrawables/dom/BitmapDrawable$Companion;", "", "()V", "SRC", "", "TINT", "drawable-preview"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

