/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import com.intellij.psi.PsiFile;
import drawables.DrawableInflater;
import drawables.Utils;
import drawables.dom.ColorDrawable;
import drawables.dom.Drawable;
import drawables.dom.IconDrawable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ldrawables/ItemDrawableInflater;", "", "()V", "Companion", "drawable-preview"})
public final class ItemDrawableInflater {
    private static final String DRAWABLE = "android:drawable";
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00062\u0006\u0010\t\u001a\u00020\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00062\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldrawables/ItemDrawableInflater$Companion;", "", "()V", "DRAWABLE", "", "getDrawable", "Lkotlin/Pair;", "Lorg/w3c/dom/Element;", "Ldrawables/dom/Drawable;", "element", "getDrawableFromAttribute", "getDrawableFromChild", "getDrawableWithInflate", "drawable-preview"})
    public static final class Companion {
        @Nullable
        public final Drawable getDrawableWithInflate(@NotNull Element element) {
            Drawable drawable;
            block1: {
                Pair<Element, Drawable> pair;
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Pair<Element, Drawable> it = pair = this.getDrawable(element);
                drawable = (Drawable)it.getSecond();
                Element elementToUse = (Element)it.getFirst();
                if (elementToUse == null) break block1;
                Drawable drawable2 = drawable;
                if (drawable2 != null) {
                    drawable2.inflate(elementToUse);
                }
            }
            return drawable;
        }

        @NotNull
        public final Pair<Element, Drawable> getDrawable(@NotNull Element element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (element.hasAttribute(ItemDrawableInflater.DRAWABLE)) {
                return TuplesKt.to(null, (Object)this.getDrawableFromAttribute(element));
            }
            if (element.hasChildNodes()) {
                return this.getDrawableFromChild(element);
            }
            return TuplesKt.to((Object)element, null);
        }

        private final Drawable getDrawableFromAttribute(Element element) {
            String drawableAttr;
            String string = drawableAttr = element.getAttribute(ItemDrawableInflater.DRAWABLE);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"drawableAttr");
            if (StringsKt.startsWith$default((String)string, (String)"#", (boolean)false, (int)2, null)) {
                return new ColorDrawable(drawableAttr);
            }
            PsiFile psiFile = Utils.Companion.getPsiFileFromPath(drawableAttr);
            if (psiFile != null) {
                PsiFile psiFile2 = psiFile;
                PsiFile it = psiFile2;
                Drawable drawable = IconPreviewFactory.Companion.createDrawable(it);
                if (drawable == null) {
                    IconDrawable iconDrawable;
                    IconDrawable $receiver = iconDrawable = new IconDrawable();
                    $receiver.setIcon(IconPreviewFactory.Companion.createIconInner(it));
                    drawable = iconDrawable;
                }
                return drawable;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Element, Drawable> getDrawableFromChild(Element element) {
            NodeList childNodes = element.getChildNodes();
            int n = 0;
            NodeList nodeList = childNodes;
            Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"childNodes");
            int n2 = nodeList.getLength();
            while (n < n2) {
                void i;
                Node childNode = childNodes.item((int)i);
                if (childNode instanceof Element) {
                    return TuplesKt.to((Object)childNode, (Object)DrawableInflater.Companion.getDrawable((Element)childNode));
                }
                ++i;
            }
            return TuplesKt.to((Object)element, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

