/*
 * Decompiled with CFR 0.152.
 */
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceUrl;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.GutterIconFactory;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ui.UIUtil;
import drawables.DrawableInflater;
import drawables.dom.Drawable;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"LIconPreviewFactory;", "", "()V", "Companion", "RetinaImageIcon", "drawable-preview"})
public final class IconPreviewFactory {
    private static final String XML_TYPE = ".xml";
    private static final String DRAWABLES_FOLDER_TYPE = "drawable";
    private static final int ICON_SIZE = 16;
    @Nullable
    private static PsiManager psiManager;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0017\u00a8\u0006\u000e"}, d2={"LIconPreviewFactory$RetinaImageIcon;", "Ljavax/swing/ImageIcon;", "image", "Ljava/awt/Image;", "(Ljava/awt/Image;)V", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "", "y", "drawable-preview"})
    private static final class RetinaImageIcon
    extends ImageIcon {
        @Override
        public synchronized void paintIcon(@NotNull Component c, @NotNull Graphics g, int x, int y) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
            UIUtil.drawImage((Graphics)g, (Image)this.getImage(), (int)x, (int)y, (ImageObserver)null);
        }

        public RetinaImageIcon(@NotNull Image image) {
            Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
            super(image, "");
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u001c\u0010\"\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0004H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"LIconPreviewFactory$Companion;", "", "()V", "DRAWABLES_FOLDER_TYPE", "", "ICON_SIZE", "", "XML_TYPE", "<set-?>", "Lcom/intellij/psi/PsiManager;", "psiManager", "getPsiManager", "()Lcom/intellij/psi/PsiManager;", "setPsiManager", "(Lcom/intellij/psi/PsiManager;)V", "createDrawable", "Ldrawables/dom/Drawable;", "element", "Lcom/intellij/psi/PsiFile;", "createIcon", "Ljavax/swing/Icon;", "Lcom/intellij/psi/PsiElement;", "createIconInner", "createXmlIcon", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolver", "Lcom/android/ide/common/resources/ResourceResolver;", "getIcon", "getResourceResolver", "getRetinaIcon", "LIconPreviewFactory$RetinaImageIcon;", "image", "Ljava/awt/image/BufferedImage;", "handleElement", "isReference", "", "attributeValue", "replaceResourceReferences", "", "node", "Lorg/w3c/dom/Node;", "drawable-preview"})
    public static final class Companion {
        @Nullable
        public final PsiManager getPsiManager() {
            return psiManager;
        }

        private final void setPsiManager(PsiManager psiManager) {
            IconPreviewFactory.psiManager = psiManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Icon createIcon(@NotNull PsiElement element) {
            Icon icon;
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            try {
                Icon result = null;
                if (element instanceof PsiFile) {
                    this.setPsiManager(((PsiFile)element).getManager());
                    result = this.createIconInner((PsiFile)element);
                }
                this.setPsiManager(null);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                icon = null;
            }
            finally {
                this.setPsiManager(null);
            }
            return icon;
        }

        @Nullable
        public final Icon createIconInner(@NotNull PsiFile element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            ResourceResolver resourceResolver = this.getResourceResolver(element);
            VirtualFile virtualFile = element.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"element.virtualFile");
            Icon icon = GutterIconFactory.createIcon((String)virtualFile.getPath(), (ResourceResolver)resourceResolver, (int)16, (int)16);
            if (icon == null) {
                VirtualFile virtualFile2 = element.getVirtualFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"element.virtualFile");
                icon = this.getIcon(virtualFile2, resourceResolver);
            }
            return icon;
        }

        @Nullable
        public final Drawable createDrawable(@NotNull PsiFile element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            VirtualFile virtualFile = element.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"element.virtualFile");
            return this.handleElement(virtualFile, this.getResourceResolver(element));
        }

        private final Icon getIcon(VirtualFile virtualFile, ResourceResolver resolver) {
            Drawable drawable;
            Drawable drawable2 = drawable = this.handleElement(virtualFile, resolver);
            if (drawable2 != null) {
                RetinaImageIcon retinaIcon;
                BufferedImage image;
                Drawable drawable3;
                Drawable it = drawable3 = drawable2;
                BufferedImage bufferedImage = image = UIUtil.createImage((int)16, (int)16, (int)2);
                Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage, (String)"image");
                drawable.draw(bufferedImage);
                if (UIUtil.isRetina() && (retinaIcon = Companion.getRetinaIcon(image)) != null) {
                    return retinaIcon;
                }
                return new ImageIcon(image);
            }
            throw (Throwable)new UnsupportedOperationException();
        }

        private final ResourceResolver getResourceResolver(PsiFile element) {
            ResourceResolver resourceResolver;
            Module module;
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)element.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(element.project)");
            Module module2 = module = projectRootManager.getFileIndex().getModuleForFile(element.getVirtualFile());
            if (module2 != null) {
                Configuration configuration;
                Module module3;
                Module it = module3 = module2;
                Configuration configuration2 = configuration = ConfigurationManager.getOrCreateInstance((Module)it).getConfiguration(element.getVirtualFile());
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
                resourceResolver = configuration2.getResourceResolver();
            } else {
                resourceResolver = null;
            }
            return resourceResolver;
        }

        private final Drawable handleElement(VirtualFile virtualFile, ResourceResolver resolver) {
            String path;
            String string = path = virtualFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
            return StringsKt.endsWith$default((String)string, (String)IconPreviewFactory.XML_TYPE, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)path, (CharSequence)IconPreviewFactory.DRAWABLES_FOLDER_TYPE, (boolean)false, (int)2, null) ? this.createXmlIcon(virtualFile, resolver) : null;
        }

        private final Drawable createXmlIcon(VirtualFile virtualFile, ResourceResolver resolver) {
            Document document;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document2 = document = documentBuilder.parse(new File(virtualFile.getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
            Element element = document2.getDocumentElement();
            if (element == null) {
                return null;
            }
            Element root = element;
            if (resolver != null) {
                this.replaceResourceReferences(root, resolver);
            }
            return DrawableInflater.Companion.getDrawable(root);
        }

        private final RetinaImageIcon getRetinaIcon(BufferedImage image) {
            BufferedImage hdpiImage;
            if (UIUtil.isRetina() && (hdpiImage = ImageUtils.convertToRetina((BufferedImage)image)) != null) {
                return new RetinaImageIcon(hdpiImage);
            }
            return null;
        }

        private final void replaceResourceReferences(Node node, ResourceResolver resolver) {
            if (node.getNodeType() == 1) {
                Node node2 = node;
                if (node2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
                }
                Element element = (Element)node2;
                NamedNodeMap attributes = element.getAttributes();
                NamedNodeMap namedNodeMap = attributes;
                Intrinsics.checkExpressionValueIsNotNull((Object)namedNodeMap, (String)"attributes");
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    String resolvedValue;
                    String value;
                    Node attribute;
                    Node node3 = attribute = attributes.item(i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)node3, (String)"attribute");
                    String string = value = node3.getNodeValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
                    if (!this.isReference(string)) continue;
                    String string2 = resolvedValue = ResourceHelper.resolveStringValue((RenderResources)((RenderResources)resolver), (String)value);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resolvedValue");
                    if (this.isReference(string2)) continue;
                    attribute.setNodeValue(resolvedValue);
                }
            }
            for (Node newNode = node.getFirstChild(); newNode != null; newNode = newNode.getNextSibling()) {
                this.replaceResourceReferences(newNode, resolver);
            }
        }

        private final boolean isReference(String attributeValue) {
            return ResourceUrl.parse((String)attributeValue) != null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

